# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Applying unitary approach

# Approach
<!-- Describe your approach to solving the problem. -->
- I kept track of all coordinates visited along the movement 
- - used HashMap for that
- If any coordinates found to be repeated then simply returned 'true'
- Otherwise 'false'
---
Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

# Complexity
- Time complexity : $$O(l)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(l^2)$$
As I'm storing coordinates : so in worst case it may possible that it takes that much space
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public boolean isPathCrossing(String path) {
        HashMap<Integer, HashSet<Integer> > coord = new HashMap<>();
        int x = 0;  // to keep track of x-coordinate of present location
        int y = 0; // to keep track of y-coordinate of present location
        HashSet<Integer> h0 = new HashSet<Integer>();
        h0.add(0);
        coord.put( 0, h0 );
        for( int i = 0; i < path.length(); i++){
            if( path.charAt(i) == 'N'){
                y++;
            } 
            else if( path.charAt(i) == 'S'){
                y--;
            } 
            else if( path.charAt(i) == 'E'){
                x++;
            } 
            else if( path.charAt(i) == 'W'){
                x--;
            } 
            //System.out.println(x + " " + y);
            // if new x-coordinate found then add to hashmap
            if( ! coord.containsKey(x)){
                coord.put(x, new HashSet<Integer>() );
            }
            // if coordinates found to be repeated then simply return 'true'
            if( coord.get(x).contains(y) ){
                return true;
            }
            // add the new coordinates as it isn't repeated
            coord.get(x).add(y);
        }
        return false;
    }
}
```